/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cpconverter.maven.mojos;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.sling.cpconverter.maven.mojos.AbstractBaseMojo;
import org.apache.sling.feature.modelconverter.ProvisioningToFeature;

@Mojo(name="convert-pm", requiresProject=true, threadSafe=true)
public final class ConvertPMMojo
extends AbstractBaseMojo {
    public static final String CFG_INPUT_FOLDER = "inputFolder";
    public static final String CFG_OUTPUT_FOLDER = "outputFolder";
    public static final String CFG_GROUP_ID = "groupId";
    public static final String CFG_ARTIFACT_ID = "artifactId";
    public static final String CFG_VERSION = "version";
    public static final String CFG_FRAMEWORK_PROPERTIES = "frameworkProperties";
    public static final String CFG_NO_PROVISIIONING_MODEL_NAME = "noProvisioningModelName";
    public static final String CFG_EXCLUDE_BUNDLES = "excludeBundles";
    public static final String CFG_RUN_MODES = "runModes";
    public static final String DEFAULT_OUTPUT_FOLDER = "target/features";
    @Parameter(property="inputFolder", required=true)
    private File inputFolder;
    @Parameter(property="outputFolder", defaultValue="target/features", required=true)
    private String outputFolder;
    @Parameter(property="groupId")
    private String groupId;
    @Parameter(property="artifactId")
    private String artifactId;
    @Parameter(property="version")
    private String version;
    @Parameter(property="frameworkProperties")
    private List<String> frameworkProperties;
    @Parameter(property="noProvisioningModelName", defaultValue="true")
    private boolean noProvisioningModelName;
    @Parameter(property="excludeBundles")
    private List<String> excludeBundles;
    @Parameter(property="runModes")
    private List<String> runModes;
    private Pattern pattern = Pattern.compile("^(.*?):(.*?)=(.*?)$");

    private String checkForPlaceholder(String text) {
        String answer = text;
        if (answer != null) {
            answer = answer.replaceAll("\\$\\{\\{", "\\$\\{");
            answer = answer.replaceAll("}}", "}");
            this.getLog().info((CharSequence)("Replaced Old Artifact Id Override: '" + text + "', with new one: '" + answer + "'"));
        }
        return answer;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.inputFolder.isDirectory()) {
            throw new MojoFailureException("Input Folder is not a directory: " + this.inputFolder);
        }
        if (!this.inputFolder.canRead()) {
            throw new MojoFailureException("Input Folder is not readable:" + this.inputFolder);
        }
        String outputFolderPath = this.project.getBasedir() + "/" + this.outputFolder;
        File output = new File(outputFolderPath);
        if (!output.exists() && !output.mkdirs()) {
            throw new MojoFailureException("Could not create Output Folder: " + this.outputFolder);
        }
        if (!output.isDirectory()) {
            throw new MojoFailureException("Output Folder is not a directory: " + output);
        }
        if (!output.canWrite()) {
            throw new MojoFailureException("Output Folder is not writable: " + output);
        }
        List<File> provisioningFiles = Arrays.asList(this.inputFolder.listFiles());
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (this.groupId != null && !this.groupId.isEmpty()) {
            this.groupId = this.checkForPlaceholder(this.groupId);
            options.put(CFG_GROUP_ID, this.groupId);
        }
        if (this.version != null && !this.version.isEmpty()) {
            this.version = this.checkForPlaceholder(this.version);
            options.put(CFG_VERSION, this.version);
        }
        if (this.artifactId != null && !this.artifactId.isEmpty()) {
            this.artifactId = this.checkForPlaceholder(this.artifactId);
            options.put("name", this.artifactId);
        }
        options.put("useProvidedVersion", this.version != null && !this.version.isEmpty());
        options.put(CFG_NO_PROVISIIONING_MODEL_NAME, this.noProvisioningModelName);
        this.frameworkProperties = this.trimList(this.frameworkProperties);
        HashMap<String, HashMap<String, String>> frameworkPropertiesMap = new HashMap<String, HashMap<String, String>>();
        for (String value : this.frameworkProperties) {
            this.getLog().info((CharSequence)("Check Add Framework Properties Line: " + value));
            Matcher matcher = this.pattern.matcher(value);
            if (!matcher.matches() || matcher.groupCount() != 3) continue;
            String modelName = matcher.group(1);
            String propName = matcher.group(2);
            String propValue = matcher.group(3);
            this.getLog().info((CharSequence)("Model Name: " + modelName + ", Prop Name: " + propName + ", Value: " + propValue));
            HashMap<String, String> modelMap = (HashMap<String, String>)frameworkPropertiesMap.get(modelName);
            if (modelMap == null) {
                modelMap = new HashMap<String, String>();
                frameworkPropertiesMap.put(modelName, modelMap);
            }
            modelMap.put(propName, propValue);
        }
        options.put("addFrameworkProperties", frameworkPropertiesMap);
        this.excludeBundles = this.trimList(this.excludeBundles);
        options.put(CFG_EXCLUDE_BUNDLES, this.excludeBundles);
        this.getLog().info((CharSequence)("Excluded Bundles: " + this.excludeBundles));
        this.runModes = this.trimList(this.runModes);
        options.put(CFG_RUN_MODES, this.runModes);
        this.getLog().info((CharSequence)("Runmodes: " + this.runModes));
        for (File file : provisioningFiles) {
            this.getLog().info((CharSequence)("Handle File: " + file.getAbsolutePath()));
            ProvisioningToFeature.convert((File)file, (File)output, options);
        }
    }

    public List<String> trimList(List<String> list) {
        ArrayList<String> answer = new ArrayList<String>();
        if (list != null) {
            for (String entry : list) {
                if (entry == null || (entry = entry.trim()).isEmpty()) continue;
                answer.add(entry);
            }
        }
        return answer;
    }
}

