/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resource.presence.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.resource.presence.ResourcePresence;
import org.apache.sling.resource.presence.internal.ResourcePresenterConfiguration;
import org.apache.sling.serviceusermapping.ServiceUserMapped;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=ResourcePresenterConfiguration.class, factory=true)
public class ResourcePresenter {
    private String path;
    private BundleContext bundleContext;
    private ServiceRegistration<ResourcePresence> presenceRegistration;
    private ServiceRegistration<ResourceChangeListener> listenerRegistration;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private ServiceUserMapped serviceUserMapped;
    private final Logger logger = LoggerFactory.getLogger(ResourcePresenter.class);

    @Activate
    public void activate(ResourcePresenterConfiguration configuration, BundleContext bundleContext) {
        this.logger.info("activating resource presenter for {}", (Object)configuration.path());
        this.path = configuration.path();
        this.bundleContext = bundleContext;
        try (ResourceResolver resourceResolver = this.getServiceResourceResolver();){
            Resource resource = resourceResolver.getResource(this.path);
            if (resource != null) {
                this.registerResourcePresence();
            }
            this.registerResourceChangeListener();
        }
        catch (LoginException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Deactivate
    public void deactivate() {
        this.logger.info("deactivating resource presenter for {}", (Object)this.path);
        this.unregisterResourceChangeListener();
        this.unregisterResourcePresence();
        this.bundleContext = null;
    }

    private ResourcePresence resourcePresence() {
        return () -> this.path;
    }

    private ResourceChangeListener resourceChangeListener() {
        return resourceChanges -> {
            for (ResourceChange resourceChange : resourceChanges) {
                if (!this.path.equals(resourceChange.getPath())) continue;
                ResourceChange.ChangeType type = resourceChange.getType();
                this.logger.info("change for {} observed: {}", (Object)this.path, (Object)type);
                if (type == ResourceChange.ChangeType.ADDED) {
                    this.unregisterResourcePresence();
                    this.registerResourcePresence();
                    continue;
                }
                if (type != ResourceChange.ChangeType.REMOVED) continue;
                this.unregisterResourcePresence();
            }
        };
    }

    private void registerResourcePresence() {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("path", this.path);
        this.presenceRegistration = this.bundleContext.registerService(ResourcePresence.class, (Object)this.resourcePresence(), properties);
        this.logger.info("resource presence for {} registered", (Object)this.path);
    }

    private void unregisterResourcePresence() {
        if (this.presenceRegistration != null) {
            this.presenceRegistration.unregister();
            this.presenceRegistration = null;
            this.logger.info("resource presence for {} unregistered", (Object)this.path);
        }
    }

    private void registerResourceChangeListener() {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("resource.paths", this.path);
        this.listenerRegistration = this.bundleContext.registerService(ResourceChangeListener.class, (Object)this.resourceChangeListener(), properties);
        this.logger.info("resource change listener for {} registered", (Object)this.path);
    }

    private void unregisterResourceChangeListener() {
        if (this.listenerRegistration != null) {
            this.listenerRegistration.unregister();
            this.listenerRegistration = null;
            this.logger.info("resource change listener for {} unregistered", (Object)this.path);
        }
    }

    private ResourceResolver getServiceResourceResolver() throws LoginException {
        return this.resourceResolverFactory.getServiceResourceResolver(null);
    }
}

