/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fsprovider.internal.parser;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.fsprovider.internal.parser.ContentElement;

final class ContentElementImpl
implements ContentElement {
    private final String name;
    private final Map<String, Object> properties;
    private final Map<String, ContentElement> children = new LinkedHashMap<String, ContentElement>();

    public ContentElementImpl(String name, Map<String, Object> properties) {
        this.name = name;
        this.properties = properties;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public Map<String, ContentElement> getChildren() {
        return this.children;
    }

    @Override
    public ContentElement getChild(String path) {
        String name = StringUtils.substringBefore((String)path, (String)"/");
        ContentElement child = this.children.get(name);
        if (child == null) {
            return null;
        }
        String remainingPath = StringUtils.substringAfter((String)path, (String)"/");
        if (StringUtils.isEmpty((CharSequence)remainingPath)) {
            return child;
        }
        return child.getChild(remainingPath);
    }
}

