/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.pngtastic.core.processing;

import com.googlecode.pngtastic.core.Logger;
import com.googlecode.pngtastic.core.processing.Base64;
import com.googlecode.pngtastic.core.processing.PngByteArrayOutputStream;
import com.googlecode.pngtastic.core.processing.PngCompressionHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class PngtasticCompressionHandler
implements PngCompressionHandler {
    private final Logger log;
    private static final List<Integer> compressionStrategies = Arrays.asList(0, 1, 2);

    public PngtasticCompressionHandler(Logger log) {
        this.log = log;
    }

    @Override
    public byte[] deflate(PngByteArrayOutputStream inflatedImageData, Integer compressionLevel, boolean concurrent) throws IOException {
        List<byte[]> results = concurrent ? this.deflateImageDataConcurrently(inflatedImageData, compressionLevel) : this.deflateImageDataSerially(inflatedImageData, compressionLevel, 0);
        byte[] result = null;
        for (int i = 0; i < results.size(); ++i) {
            byte[] data = results.get(i);
            if (result != null && data.length >= result.length) continue;
            result = data;
        }
        this.log.debug("Image bytes=%d", result == null ? -1 : result.length);
        return result;
    }

    @Override
    public String encodeBytes(byte[] bytes) {
        return Base64.encodeBytes(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<byte[]> deflateImageDataConcurrently(final PngByteArrayOutputStream inflatedImageData, final Integer compressionLevel) {
        final ConcurrentLinkedQueue results = new ConcurrentLinkedQueue();
        ArrayList<Callable<Object>> tasks = new ArrayList<Callable<Object>>();
        for (final int strategy : compressionStrategies) {
            tasks.add(Executors.callable(new Runnable(){

                @Override
                public void run() {
                    try {
                        results.add(PngtasticCompressionHandler.this.deflateImageData(inflatedImageData, strategy, compressionLevel));
                    }
                    catch (Throwable e) {
                        PngtasticCompressionHandler.this.log.error("Uncaught Exception: %s", e.getMessage());
                    }
                }
            }));
        }
        ExecutorService compressionThreadPool = Executors.newFixedThreadPool(compressionStrategies.size());
        try {
            compressionThreadPool.invokeAll(tasks);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            compressionThreadPool.shutdown();
        }
        return new ArrayList<byte[]>(results);
    }

    private List<byte[]> deflateImageDataSerially(PngByteArrayOutputStream inflatedImageData, Integer compressionLevel, Integer compressionStrategy) {
        ArrayList<byte[]> results = new ArrayList<byte[]>();
        List<Integer> strategies = compressionStrategy == null ? compressionStrategies : Collections.singletonList(compressionStrategy);
        for (int strategy : strategies) {
            try {
                results.add(this.deflateImageData(inflatedImageData, strategy, compressionLevel));
            }
            catch (Throwable e) {
                this.log.error("Uncaught Exception: %s", e.getMessage());
            }
        }
        return results;
    }

    private byte[] deflateImageData(PngByteArrayOutputStream inflatedImageData, int strategy, Integer compressionLevel) throws IOException {
        byte[] result = null;
        int bestCompression = 9;
        if (compressionLevel == null || compressionLevel > 9 || compressionLevel < 0) {
            for (int compression = 9; compression > 0; --compression) {
                ByteArrayOutputStream deflatedOut = this.deflate(inflatedImageData, strategy, compression);
                if (result != null && result.length <= deflatedOut.size()) continue;
                result = deflatedOut.toByteArray();
                bestCompression = compression;
            }
        } else {
            result = this.deflate(inflatedImageData, strategy, compressionLevel).toByteArray();
            bestCompression = compressionLevel;
        }
        this.log.debug("Compression strategy: %s, compression level=%d, bytes=%d", strategy, bestCompression, result == null ? -1 : result.length);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteArrayOutputStream deflate(PngByteArrayOutputStream inflatedImageData, int strategy, int compression) throws IOException {
        ByteArrayOutputStream deflatedOut = new ByteArrayOutputStream();
        Deflater deflater = new Deflater(compression);
        deflater.setStrategy(strategy);
        try {
            DeflaterOutputStream stream = new DeflaterOutputStream((OutputStream)deflatedOut, deflater);
            stream.write(inflatedImageData.get(), 0, inflatedImageData.len());
            stream.close();
        }
        finally {
            deflater.end();
        }
        return deflatedOut;
    }
}

