/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.discovery;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.apache.sling.distribution.journal.impl.discovery.TopologyView;

@ParametersAreNonnullByDefault
@Immutable
public class TopologyViewDiff {
    private final Map<String, Long> oldOffsets;
    private final Map<String, Long> newOffsets;
    private final boolean subAgentChanged;

    public TopologyViewDiff(TopologyView oldView, TopologyView newView) {
        this.oldOffsets = Collections.unmodifiableMap(oldView.getMinOffsetByPubAgentName());
        this.newOffsets = Collections.unmodifiableMap(newView.getMinOffsetByPubAgentName());
        this.subAgentChanged = !Objects.equals(oldView.getSubscribedAgentIds(), newView.getSubscribedAgentIds());
    }

    public Map<String, Supplier<LongStream>> getProcessedOffsets() {
        return this.retainedPubAgentNames().stream().filter(this::newOffsetIsHigher).collect(Collectors.toMap(Function.identity(), this::offsetRange));
    }

    public boolean subscribedAgentsChanged() {
        return this.subAgentChanged;
    }

    private boolean newOffsetIsHigher(String pubAgentName) {
        return this.newOffsets.get(pubAgentName) > this.oldOffsets.get(pubAgentName);
    }

    private Supplier<LongStream> offsetRange(String pubAgentName) {
        return () -> LongStream.rangeClosed(this.oldOffsets.get(pubAgentName) + 1L, this.newOffsets.get(pubAgentName));
    }

    private Set<String> retainedPubAgentNames() {
        return this.retained(this.oldOffsets.keySet(), this.newOffsets.keySet());
    }

    private <T> Set<T> retained(Set<T> oldSet, Set<T> newSet) {
        HashSet<T> retained = new HashSet<T>(newSet);
        retained.retainAll(oldSet);
        return retained;
    }
}

