/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import jakarta.json.JsonNumber;
import jakarta.json.JsonValue;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.function.Consumer;

final class JsonNumberImpl
implements JsonNumber,
Serializable {
    private final BigDecimal value;
    private transient Integer hashCode = null;
    private transient Consumer<BigDecimal> maxBigDecimalScale = bigDecimal -> {};

    JsonNumberImpl(BigDecimal decimal, Consumer<BigDecimal> maxBigDecimalScale) {
        this.maxBigDecimalScale = maxBigDecimalScale;
        if (decimal == null) {
            throw new NullPointerException("decimal must not be null");
        }
        this.value = decimal;
    }

    @Override
    public Number numberValue() {
        return this.value;
    }

    @Override
    public boolean isIntegral() {
        return this.value.scale() == 0;
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public int intValueExact() {
        this.checkFractionalPart();
        return this.value.intValueExact();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public long longValueExact() {
        this.checkFractionalPart();
        return this.value.longValueExact();
    }

    @Override
    public BigInteger bigIntegerValue() {
        this.maxBigDecimalScale.accept(this.value);
        return this.value.toBigInteger();
    }

    @Override
    public BigInteger bigIntegerValueExact() {
        this.maxBigDecimalScale.accept(this.value);
        return this.value.toBigIntegerExact();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return this.value;
    }

    @Override
    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.NUMBER;
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    @Override
    public int hashCode() {
        Integer h = this.hashCode;
        if (h == null) {
            this.hashCode = h = Integer.valueOf(this.value.hashCode());
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        return JsonNumber.class.isInstance(obj) && ((JsonNumber)JsonNumber.class.cast(obj)).bigDecimalValue().equals(this.value);
    }

    private void checkFractionalPart() {
        if (this.value.remainder(BigDecimal.ONE).doubleValue() != 0.0) {
            throw new ArithmeticException("Not an int/long, use other value readers");
        }
    }
}

