/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;

public class MessageBundle
extends ResourceBundle {
    private static final ThreadLocal<Locale> clientLocale = new ThreadLocal();
    private final ResourceBundle rb;
    private final String bundlePath;
    private final String className;
    private final Class<?> forClass;
    private final long creationThreadId;
    private final Map<String, String> keyMap = new ConcurrentHashMap<String, String>();
    private final ConcurrentSkipListSet<String> allKeys = new ConcurrentSkipListSet();
    private final CopyOnWriteArrayList<MessageBundle> searchBundles = new CopyOnWriteArrayList();
    private final ConcurrentHashMap<Locale, MessageBundle> localizedBundles = new ConcurrentHashMap();

    public static void setClientLocale(Locale locale) {
        clientLocale.set(locale);
    }

    public static final MessageBundle create(Class<?> forClass) {
        return MessageBundle.create(forClass, MessageBundle.findBundlePath(forClass));
    }

    public static final MessageBundle create(Class<?> forClass, String bundlePath) {
        return new MessageBundle(forClass, bundlePath);
    }

    private static final String findBundlePath(Class<?> forClass) {
        String path = forClass.getName();
        if (MessageBundle.tryBundlePath(forClass, path)) {
            return path;
        }
        path = forClass.getPackage().getName() + ".nls." + forClass.getSimpleName();
        if (MessageBundle.tryBundlePath(forClass, path)) {
            return path;
        }
        path = forClass.getPackage().getName() + ".i18n." + forClass.getSimpleName();
        if (MessageBundle.tryBundlePath(forClass, path)) {
            return path;
        }
        return null;
    }

    private static final boolean tryBundlePath(Class<?> c, String path) {
        try {
            path = c.getName();
            ResourceBundle.getBundle(path, Locale.getDefault(), c.getClassLoader());
            return true;
        }
        catch (MissingResourceException e) {
            return false;
        }
    }

    public MessageBundle(Class<?> forClass, String bundlePath) {
        this(forClass, bundlePath, Locale.getDefault());
    }

    private MessageBundle(Class<?> forClass, String bundlePath, Locale locale) {
        this.forClass = forClass;
        this.className = forClass.getSimpleName();
        if (bundlePath == null) {
            throw new RuntimeException("Bundle path was null.");
        }
        if (bundlePath.endsWith(".properties")) {
            throw new RuntimeException("Bundle path should not end with '.properties'");
        }
        this.bundlePath = bundlePath;
        this.creationThreadId = Thread.currentThread().getId();
        ClassLoader cl = forClass.getClassLoader();
        ResourceBundle trb = null;
        try {
            trb = ResourceBundle.getBundle(bundlePath, locale, cl);
        }
        catch (MissingResourceException e) {
            try {
                trb = ResourceBundle.getBundle(forClass.getPackage().getName() + '.' + bundlePath, locale, cl);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        this.rb = trb;
        if (this.rb != null) {
            Enumeration<String> e = this.getKeys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                this.keyMap.put(key, key);
            }
            String c = this.className + '.';
            Enumeration<String> e2 = this.getKeys();
            while (e2.hasMoreElements()) {
                String key = e2.nextElement();
                if (!key.startsWith(c)) continue;
                String shortKey = key.substring(this.className.length() + 1);
                this.keyMap.put(shortKey, key);
            }
            this.allKeys.addAll(this.keyMap.keySet());
        }
        this.searchBundles.add(this);
    }

    public MessageBundle addSearchPath(Class<?> forClass, String bundlePath) {
        ThrowableUtils.assertSameThread(this.creationThreadId, "This method can only be called from the same thread that created the object.", new Object[0]);
        MessageBundle srb = new MessageBundle(forClass, bundlePath);
        if (srb.rb != null) {
            this.allKeys.addAll(srb.keySet());
            this.searchBundles.add(srb);
        }
        return this;
    }

    @Override
    public boolean containsKey(String key) {
        return this.allKeys.contains(key);
    }

    public String getString(String key, Object ... args) {
        String s = this.getString(key);
        if (s.length() > 0 && s.charAt(0) == '{') {
            return s;
        }
        return StringUtils.format(s, args);
    }

    public String getString(Locale locale, String key, Object ... args) {
        if (locale == null) {
            return this.getString(key, args);
        }
        return this.getBundle(locale).getString(key, args);
    }

    public String getClientString(String key, Object ... args) {
        return this.getString(clientLocale.get(), key, args);
    }

    public String findFirstString(String ... keys) {
        if (this.rb == null) {
            return null;
        }
        for (String k : keys) {
            if (!this.containsKey(k)) continue;
            return this.getString(k);
        }
        return null;
    }

    public String findFirstString(Locale locale, String ... keys) {
        MessageBundle srb = this.getBundle(locale);
        return srb.findFirstString(keys);
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.allKeys);
    }

    public Set<String> keySet(String prefix) {
        HashSet<String> set = new HashSet<String>();
        for (String s : this.keySet()) {
            if (!s.equals(prefix) && (!s.startsWith(prefix) || s.charAt(prefix.length()) != '.')) continue;
            set.add(s);
        }
        return set;
    }

    @Override
    public Enumeration<String> getKeys() {
        if (this.rb == null) {
            return new Vector(0).elements();
        }
        return this.rb.getKeys();
    }

    @Override
    protected Object handleGetObject(String key) {
        for (MessageBundle srb : this.searchBundles) {
            String key2;
            if (srb.rb == null || (key2 = srb.keyMap.get(key)) == null) continue;
            try {
                return srb.rb.getObject(key2);
            }
            catch (Exception e) {
                return "{!" + key + "}";
            }
        }
        if (this.rb == null) {
            return "{!!" + key + "}";
        }
        return "{!" + key + "}";
    }

    public ObjectMap swap() {
        ObjectMap om = new ObjectMap();
        for (String k : this.allKeys) {
            om.put(k, this.getString(k));
        }
        return om;
    }

    public MessageBundle getBundle(Locale locale) {
        MessageBundle mb = this.localizedBundles.get(locale);
        if (mb != null) {
            return mb;
        }
        mb = new MessageBundle(this.forClass, this.bundlePath, locale);
        ArrayList<MessageBundle> l = new ArrayList<MessageBundle>(this.searchBundles.size() - 1);
        for (int i = 1; i < this.searchBundles.size(); ++i) {
            MessageBundle srb = this.searchBundles.get(i);
            srb = new MessageBundle(srb.forClass, srb.bundlePath, locale);
            l.add(srb);
            mb.allKeys.addAll(srb.keySet());
        }
        mb.searchBundles.addAll(l);
        this.localizedBundles.putIfAbsent(locale, mb);
        return this.localizedBundles.get(locale);
    }
}

