/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dprofile.util;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

class Area<T extends Pair<Long, Double>> {
    private final T generator;
    private final double value;

    private Area(T generator, double value) {
        this.generator = generator;
        this.value = value;
    }

    static <U extends Pair<Long, Double>> Area<U> ofTriangle(Pair<Long, Double> a, U b, Pair<Long, Double> c) {
        List<Double> addends = Arrays.asList((double)a.getLeft().longValue() * (b.getRight() - c.getRight()), (double)b.getLeft().longValue() * (c.getRight() - a.getRight()), (double)c.getLeft().longValue() * (a.getRight() - b.getRight()));
        double sum = addends.stream().reduce(0.0, Double::sum);
        double value = Math.abs(sum / 2.0);
        return new Area<U>(b, value);
    }

    T getGenerator() {
        return this.generator;
    }

    public double getValue() {
        return this.value;
    }
}

