/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.deployment;

import java.util.Objects;
import org.apache.ignite.shaded.org.apache.ignite.deployment.version.Version;

public class DeploymentUnit {
    private final String name;
    private final Version version;

    public DeploymentUnit(String name, Version version) {
        this.name = name;
        this.version = version;
    }

    public DeploymentUnit(String name, String version) {
        this(name, Version.parseVersion(version));
    }

    public String name() {
        return this.name;
    }

    public Version version() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentUnit unit = (DeploymentUnit)o;
        return Objects.equals(this.name, unit.name) && Objects.equals(this.version, unit.version);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version);
    }

    public String toString() {
        return "DeploymentUnit{name='" + this.name + "', version=" + String.valueOf(this.version) + "}";
    }

    public String render() {
        return this.name + ":" + String.valueOf(this.version);
    }
}

