/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.webconsole;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.HandlerFactory;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.apache.felix.ipojo.architecture.Architecture;
import org.apache.felix.ipojo.architecture.HandlerDescription;
import org.apache.felix.ipojo.architecture.InstanceDescription;
import org.apache.felix.ipojo.architecture.PropertyDescription;
import org.apache.felix.ipojo.handlers.dependency.DependencyDescription;
import org.apache.felix.ipojo.handlers.dependency.DependencyHandlerDescription;
import org.apache.felix.ipojo.handlers.providedservice.ProvidedServiceDescription;
import org.apache.felix.ipojo.handlers.providedservice.ProvidedServiceHandlerDescription;
import org.apache.felix.ipojo.webconsole.StateUtils;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.felix.webconsole.DefaultVariableResolver;
import org.apache.felix.webconsole.WebConsoleUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(immediate=true)
@Provides
@Instantiate
public class IPOJOPlugin
extends AbstractWebConsolePlugin
implements Pojo {
    private InstanceManager __IM;
    private static final String[] CSS = new String[]{"/res/ui/bundles.css", "/iPOJO/res/ui/ipojo.css"};
    private boolean __FINSTANCES;
    private final String INSTANCES;
    private boolean __FFACTORIES;
    private final String FACTORIES;
    private boolean __FHANDLERS;
    private final String HANDLERS;
    private boolean __FFACTORY_DETAILS;
    private final String FACTORY_DETAILS;
    private boolean __FINSTANCE_DETAILS;
    private final String INSTANCE_DETAILS;
    private boolean __Fm_label;
    @ServiceProperty(name="felix.webconsole.label")
    private String m_label;
    private boolean __Fm_title;
    @ServiceProperty(name="felix.webconsole.title")
    private String m_title;
    private boolean __Fm_css;
    @ServiceProperty(name="felix.webconsole.css")
    protected String[] m_css;
    private boolean __Fm_archs;
    @Requires(optional=true, specification="org.apache.felix.ipojo.architecture.Architecture")
    private List<Architecture> m_archs;
    private boolean __Fm_factories;
    @Requires(optional=true, specification="org.apache.felix.ipojo.Factory")
    private List<Factory> m_factories;
    private boolean __Fm_handlers;
    @Requires(optional=true, specification="org.apache.felix.ipojo.HandlerFactory")
    private List<HandlerFactory> m_handlers;
    private boolean __MreadTemplate$java_lang_String;
    private boolean __MrenderContent$javax_servlet_http_HttpServletRequest$javax_servlet_http_HttpServletResponse;
    private boolean __MgetAllInstances$java_io_PrintWriter;
    private boolean __MgetAllFactories$java_io_PrintWriter;
    private boolean __MgetAllHandlers$java_io_PrintWriter;
    private boolean __MgetFactoryDetail$java_io_PrintWriter$java_lang_String;
    private boolean __MgetInstanceDetail$java_io_PrintWriter$java_lang_String;
    private boolean __MdoGet$javax_servlet_http_HttpServletRequest$javax_servlet_http_HttpServletResponse;
    private boolean __MgetResource$java_lang_String;
    private boolean __MgetProvidedServiceDetail$org_apache_felix_ipojo_architecture_HandlerDescription;
    private boolean __MgetServiceProperties$java_util_Properties;
    private boolean __MgetRequiredServiceDetail$org_apache_felix_ipojo_architecture_HandlerDescription;
    private boolean __MgetServiceReferenceList$java_util_List;
    private boolean __MgetLabel;
    private boolean __MgetTitle;
    private boolean __MgetCssReferences;

    String __getINSTANCES() {
        if (!this.__FINSTANCES) {
            return this.INSTANCES;
        }
        return (String)this.__IM.onGet((Object)this, "INSTANCES");
    }

    void __setINSTANCES(String string) {
        if (!this.__FINSTANCES) {
            this.INSTANCES = string;
            return;
        }
        this.__IM.onSet((Object)this, "INSTANCES", (Object)string);
    }

    String __getFACTORIES() {
        if (!this.__FFACTORIES) {
            return this.FACTORIES;
        }
        return (String)this.__IM.onGet((Object)this, "FACTORIES");
    }

    void __setFACTORIES(String string) {
        if (!this.__FFACTORIES) {
            this.FACTORIES = string;
            return;
        }
        this.__IM.onSet((Object)this, "FACTORIES", (Object)string);
    }

    String __getHANDLERS() {
        if (!this.__FHANDLERS) {
            return this.HANDLERS;
        }
        return (String)this.__IM.onGet((Object)this, "HANDLERS");
    }

    void __setHANDLERS(String string) {
        if (!this.__FHANDLERS) {
            this.HANDLERS = string;
            return;
        }
        this.__IM.onSet((Object)this, "HANDLERS", (Object)string);
    }

    String __getFACTORY_DETAILS() {
        if (!this.__FFACTORY_DETAILS) {
            return this.FACTORY_DETAILS;
        }
        return (String)this.__IM.onGet((Object)this, "FACTORY_DETAILS");
    }

    void __setFACTORY_DETAILS(String string) {
        if (!this.__FFACTORY_DETAILS) {
            this.FACTORY_DETAILS = string;
            return;
        }
        this.__IM.onSet((Object)this, "FACTORY_DETAILS", (Object)string);
    }

    String __getINSTANCE_DETAILS() {
        if (!this.__FINSTANCE_DETAILS) {
            return this.INSTANCE_DETAILS;
        }
        return (String)this.__IM.onGet((Object)this, "INSTANCE_DETAILS");
    }

    void __setINSTANCE_DETAILS(String string) {
        if (!this.__FINSTANCE_DETAILS) {
            this.INSTANCE_DETAILS = string;
            return;
        }
        this.__IM.onSet((Object)this, "INSTANCE_DETAILS", (Object)string);
    }

    String __getm_label() {
        if (!this.__Fm_label) {
            return this.m_label;
        }
        return (String)this.__IM.onGet((Object)this, "m_label");
    }

    void __setm_label(String string) {
        if (!this.__Fm_label) {
            this.m_label = string;
            return;
        }
        this.__IM.onSet((Object)this, "m_label", (Object)string);
    }

    String __getm_title() {
        if (!this.__Fm_title) {
            return this.m_title;
        }
        return (String)this.__IM.onGet((Object)this, "m_title");
    }

    void __setm_title(String string) {
        if (!this.__Fm_title) {
            this.m_title = string;
            return;
        }
        this.__IM.onSet((Object)this, "m_title", (Object)string);
    }

    String[] __getm_css() {
        if (!this.__Fm_css) {
            return this.m_css;
        }
        return (String[])this.__IM.onGet((Object)this, "m_css");
    }

    void __setm_css(String[] stringArray) {
        if (!this.__Fm_css) {
            this.m_css = stringArray;
            return;
        }
        this.__IM.onSet((Object)this, "m_css", (Object)stringArray);
    }

    List __getm_archs() {
        if (!this.__Fm_archs) {
            return this.m_archs;
        }
        return (List)this.__IM.onGet((Object)this, "m_archs");
    }

    void __setm_archs(List list) {
        if (!this.__Fm_archs) {
            this.m_archs = list;
            return;
        }
        this.__IM.onSet((Object)this, "m_archs", (Object)list);
    }

    List __getm_factories() {
        if (!this.__Fm_factories) {
            return this.m_factories;
        }
        return (List)this.__IM.onGet((Object)this, "m_factories");
    }

    void __setm_factories(List list) {
        if (!this.__Fm_factories) {
            this.m_factories = list;
            return;
        }
        this.__IM.onSet((Object)this, "m_factories", (Object)list);
    }

    List __getm_handlers() {
        if (!this.__Fm_handlers) {
            return this.m_handlers;
        }
        return (List)this.__IM.onGet((Object)this, "m_handlers");
    }

    void __setm_handlers(List list) {
        if (!this.__Fm_handlers) {
            this.m_handlers = list;
            return;
        }
        this.__IM.onSet((Object)this, "m_handlers", (Object)list);
    }

    public IPOJOPlugin() {
        this(null);
    }

    private IPOJOPlugin(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setm_label("iPOJO");
        this.__setm_title("iPOJO");
        this.__setm_css(CSS);
        this.__setINSTANCES(this.readTemplate("/res/instances.html"));
        this.__setFACTORIES(this.readTemplate("/res/factories.html"));
        this.__setHANDLERS(this.readTemplate("/res/handlers.html"));
        this.__setFACTORY_DETAILS(this.readTemplate("/res/factory.html"));
        this.__setINSTANCE_DETAILS(this.readTemplate("/res/instance.html"));
    }

    private final String readTemplate(String templateFile) {
        String string;
        if (!this.__MreadTemplate$java_lang_String) {
            return this.__M_readTemplate(templateFile);
        }
        try {
            this.__IM.onEntry((Object)this, "readTemplate$java_lang_String", new Object[]{templateFile});
            string = this.__M_readTemplate(templateFile);
            this.__IM.onExit((Object)this, "readTemplate$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "readTemplate$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_readTemplate(String templateFile) {
        InputStream templateStream = ((Object)((Object)this)).getClass().getResourceAsStream(templateFile);
        if (templateStream != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            try {
                int len = 0;
                while ((len = templateStream.read(data)) > 0) {
                    baos.write(data, 0, len);
                }
                String string = baos.toString("UTF-8");
                return string;
            }
            catch (IOException e) {
                throw new RuntimeException("readTemplateFile: Error loading " + templateFile + ": " + e);
            }
            finally {
                try {
                    templateStream.close();
                }
                catch (IOException e) {}
            }
        }
        this.log("readTemplateFile: File '" + templateFile + "' not found through class " + ((Object)((Object)this)).getClass());
        return "";
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.__MrenderContent$javax_servlet_http_HttpServletRequest$javax_servlet_http_HttpServletResponse) {
            this.__M_renderContent(request, response);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "renderContent$javax_servlet_http_HttpServletRequest$javax_servlet_http_HttpServletResponse", new Object[]{request, response});
            this.__M_renderContent(request, response);
            this.__IM.onExit((Object)this, "renderContent$javax_servlet_http_HttpServletRequest$javax_servlet_http_HttpServletResponse", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "renderContent$javax_servlet_http_HttpServletRequest$javax_servlet_http_HttpServletResponse", throwable);
            throw throwable;
        }
    }

    private void __M_renderContent(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestInfo reqInfo = new RequestInfo(request);
        DefaultVariableResolver vars = (DefaultVariableResolver)WebConsoleUtil.getVariableResolver((ServletRequest)request);
        if (reqInfo.instances) {
            if (reqInfo.name == null) {
                response.getWriter().print(this.__getINSTANCES());
            } else {
                vars.put((Object)"name", (Object)reqInfo.name);
                response.getWriter().print(this.__getINSTANCE_DETAILS());
            }
        } else if (reqInfo.factories) {
            if (reqInfo.name == null) {
                response.getWriter().print(this.__getFACTORIES());
            } else {
                vars.put((Object)"name", (Object)reqInfo.name);
                response.getWriter().print(this.__getFACTORY_DETAILS());
            }
        } else if (reqInfo.handlers) {
            response.getWriter().print(this.__getHANDLERS());
        } else {
            response.getWriter().print(this.__getINSTANCES());
        }
    }

    private void getAllInstances(PrintWriter pw) throws IOException {
        if (!this.__MgetAllInstances$java_io_PrintWriter) {
            this.__M_getAllInstances(pw);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "getAllInstances$java_io_PrintWriter", new Object[]{pw});
            this.__M_getAllInstances(pw);
            this.__IM.onExit((Object)this, "getAllInstances$java_io_PrintWriter", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getAllInstances$java_io_PrintWriter", throwable);
            throw throwable;
        }
    }

    private void __M_getAllInstances(PrintWriter pw) throws IOException {
        try {
            JSONObject resp = new JSONObject();
            resp.put("count", this.__getm_archs().size());
            resp.put("valid_count", StateUtils.getValidInstancesCount(this.__getm_archs()));
            resp.put("invalid_count", StateUtils.getInvalidInstancesCount(this.__getm_archs()));
            JSONArray instances = new JSONArray();
            for (Architecture arch : this.__getm_archs()) {
                JSONObject instance = new JSONObject();
                instance.put("name", (Object)arch.getInstanceDescription().getName());
                instance.put("factory", (Object)arch.getInstanceDescription().getComponentDescription().getName());
                instance.put("state", (Object)StateUtils.getInstanceState(arch.getInstanceDescription().getState()));
                instances.put((Object)instance);
            }
            resp.put("data", (Object)instances);
            pw.print(resp.toString());
        }
        catch (JSONException e) {
            throw new IOException(e.toString());
        }
    }

    private void getAllFactories(PrintWriter pw) throws IOException {
        if (!this.__MgetAllFactories$java_io_PrintWriter) {
            this.__M_getAllFactories(pw);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "getAllFactories$java_io_PrintWriter", new Object[]{pw});
            this.__M_getAllFactories(pw);
            this.__IM.onExit((Object)this, "getAllFactories$java_io_PrintWriter", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getAllFactories$java_io_PrintWriter", throwable);
            throw throwable;
        }
    }

    private void __M_getAllFactories(PrintWriter pw) throws IOException {
        try {
            JSONObject resp = new JSONObject();
            resp.put("count", this.__getm_factories().size());
            resp.put("valid_count", StateUtils.getValidFactoriesCount(this.__getm_factories()));
            resp.put("invalid_count", StateUtils.getInvalidFactoriesCount(this.__getm_factories()));
            JSONArray factories = new JSONArray();
            for (Factory factory : this.__getm_factories()) {
                String version = factory.getVersion();
                String name = factory.getName();
                String state = StateUtils.getFactoryState(factory.getState());
                String bundle = factory.getBundleContext().getBundle().getSymbolicName() + " (" + factory.getBundleContext().getBundle().getBundleId() + ")";
                JSONObject fact = new JSONObject();
                fact.put("name", (Object)name);
                if (version != null) {
                    fact.put("version", (Object)version);
                }
                fact.put("bundle", (Object)bundle);
                fact.put("state", (Object)state);
                factories.put((Object)fact);
            }
            resp.put("data", (Object)factories);
            pw.print(resp.toString());
        }
        catch (JSONException e) {
            throw new IOException(e.toString());
        }
    }

    private void getAllHandlers(PrintWriter pw) throws IOException {
        if (!this.__MgetAllHandlers$java_io_PrintWriter) {
            this.__M_getAllHandlers(pw);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "getAllHandlers$java_io_PrintWriter", new Object[]{pw});
            this.__M_getAllHandlers(pw);
            this.__IM.onExit((Object)this, "getAllHandlers$java_io_PrintWriter", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getAllHandlers$java_io_PrintWriter", throwable);
            throw throwable;
        }
    }

    private void __M_getAllHandlers(PrintWriter pw) throws IOException {
        try {
            JSONObject resp = new JSONObject();
            resp.put("count", this.__getm_handlers().size());
            resp.put("valid_count", StateUtils.getValidHandlersCount(this.__getm_handlers()));
            resp.put("invalid_count", StateUtils.getInvalidHandlersCount(this.__getm_handlers()));
            JSONArray factories = new JSONArray();
            for (HandlerFactory factory : this.__getm_handlers()) {
                String version = factory.getVersion();
                String name = factory.getHandlerName();
                String state = StateUtils.getFactoryState(factory.getState());
                String bundle = factory.getBundleContext().getBundle().getSymbolicName() + " (" + factory.getBundleContext().getBundle().getBundleId() + ")";
                JSONObject fact = new JSONObject();
                fact.put("name", (Object)name);
                if (version != null) {
                    fact.put("version", (Object)version);
                }
                fact.put("bundle", (Object)bundle);
                fact.put("state", (Object)state);
                fact.put("type", (Object)factory.getType());
                if (!factory.getMissingHandlers().isEmpty()) {
                    fact.put("missing", (Object)factory.getMissingHandlers().toString());
                }
                factories.put((Object)fact);
            }
            resp.put("data", (Object)factories);
            pw.print(resp.toString());
        }
        catch (JSONException e) {
            throw new IOException(e.toString());
        }
    }

    private void getFactoryDetail(PrintWriter pw, String name) throws IOException {
        if (!this.__MgetFactoryDetail$java_io_PrintWriter$java_lang_String) {
            this.__M_getFactoryDetail(pw, name);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "getFactoryDetail$java_io_PrintWriter$java_lang_String", new Object[]{pw, name});
            this.__M_getFactoryDetail(pw, name);
            this.__IM.onExit((Object)this, "getFactoryDetail$java_io_PrintWriter$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getFactoryDetail$java_io_PrintWriter$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_getFactoryDetail(PrintWriter pw, String name) throws IOException {
        Factory factory = null;
        for (Factory fact : this.__getm_factories()) {
            if (!fact.getName().equals(name)) continue;
            factory = fact;
        }
        if (factory == null) {
            pw.println("The factory " + name + " does not exist or is private");
            return;
        }
        try {
            List<String> instances;
            JSONArray req;
            PropertyDescription[] props;
            JSONObject resp = new JSONObject();
            resp.put("count", this.__getm_factories().size());
            resp.put("valid_count", StateUtils.getValidFactoriesCount(this.__getm_factories()));
            resp.put("invalid_count", StateUtils.getInvalidFactoriesCount(this.__getm_factories()));
            JSONObject data = new JSONObject();
            data.put("name", (Object)factory.getName());
            data.put("state", (Object)StateUtils.getFactoryState(factory.getState()));
            String bundle = factory.getBundleContext().getBundle().getSymbolicName() + " (" + factory.getBundleContext().getBundle().getBundleId() + ")";
            data.put("bundle", (Object)bundle);
            if (factory.getComponentDescription().getprovidedServiceSpecification().length != 0) {
                JSONArray services = new JSONArray(Arrays.asList(factory.getComponentDescription().getprovidedServiceSpecification()));
                data.put("services", (Object)services);
            }
            if ((props = factory.getComponentDescription().getProperties()) != null && props.length != 0) {
                JSONArray properties = new JSONArray();
                for (int i = 0; i < props.length; ++i) {
                    JSONObject prop = new JSONObject();
                    prop.put("name", (Object)props[i].getName());
                    prop.put("type", (Object)props[i].getType());
                    prop.put("mandatory", props[i].isMandatory());
                    prop.put("immutable", props[i].isImmutable());
                    if (props[i].getValue() != null) {
                        prop.put("value", (Object)props[i].getValue());
                    }
                    properties.put((Object)prop);
                }
                data.put("properties", (Object)properties);
            }
            if (!factory.getRequiredHandlers().isEmpty()) {
                req = new JSONArray((Collection)factory.getRequiredHandlers());
                data.put("requiredHandlers", (Object)req);
            }
            if (!factory.getMissingHandlers().isEmpty()) {
                req = new JSONArray((Collection)factory.getMissingHandlers());
                data.put("missingHandlers", (Object)req);
            }
            if (!(instances = StateUtils.getInstanceList(this.__getm_archs(), name)).isEmpty()) {
                JSONArray req2 = new JSONArray(instances);
                data.put("instances", (Object)req2);
            }
            data.put("architecture", (Object)factory.getDescription().toString());
            resp.put("data", (Object)data);
            pw.print(resp.toString());
        }
        catch (JSONException e) {
            throw new IOException(e.toString());
        }
    }

    private void getInstanceDetail(PrintWriter pw, String name) throws IOException {
        if (!this.__MgetInstanceDetail$java_io_PrintWriter$java_lang_String) {
            this.__M_getInstanceDetail(pw, name);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "getInstanceDetail$java_io_PrintWriter$java_lang_String", new Object[]{pw, name});
            this.__M_getInstanceDetail(pw, name);
            this.__IM.onExit((Object)this, "getInstanceDetail$java_io_PrintWriter$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getInstanceDetail$java_io_PrintWriter$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_getInstanceDetail(PrintWriter pw, String name) throws IOException {
        InstanceDescription instance = null;
        for (Architecture arch : this.__getm_archs()) {
            if (!arch.getInstanceDescription().getName().equals(name)) continue;
            instance = arch.getInstanceDescription();
        }
        if (instance == null) {
            pw.println("The instance " + name + " does not exist or " + "does not exposed its architecture");
            return;
        }
        try {
            JSONArray reqs;
            JSONObject resp = new JSONObject();
            resp.put("count", this.__getm_factories().size());
            resp.put("valid_count", StateUtils.getValidFactoriesCount(this.__getm_factories()));
            resp.put("invalid_count", StateUtils.getInvalidFactoriesCount(this.__getm_factories()));
            JSONObject data = new JSONObject();
            data.put("name", (Object)instance.getName());
            data.put("state", (Object)StateUtils.getInstanceState(instance.getState()));
            data.put("factory", (Object)instance.getComponentDescription().getName());
            JSONArray services = this.getProvidedServiceDetail(instance.getHandlerDescription("org.apache.felix.ipojo:provides"));
            if (services != null) {
                data.put("services", (Object)services);
            }
            if ((reqs = this.getRequiredServiceDetail(instance.getHandlerDescription("org.apache.felix.ipojo:requires"))) != null) {
                data.put("req", (Object)reqs);
            }
            data.put("architecture", (Object)instance.getDescription().toString());
            resp.put("data", (Object)data);
            pw.print(resp.toString());
        }
        catch (JSONException e) {
            throw new IOException(e.toString());
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.__MdoGet$javax_servlet_http_HttpServletRequest$javax_servlet_http_HttpServletResponse) {
            this.__M_doGet(request, response);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doGet$javax_servlet_http_HttpServletRequest$javax_servlet_http_HttpServletResponse", new Object[]{request, response});
            this.__M_doGet(request, response);
            this.__IM.onExit((Object)this, "doGet$javax_servlet_http_HttpServletRequest$javax_servlet_http_HttpServletResponse", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doGet$javax_servlet_http_HttpServletRequest$javax_servlet_http_HttpServletResponse", throwable);
            throw throwable;
        }
    }

    private void __M_doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestInfo reqInfo = new RequestInfo(request);
        if (reqInfo.extension.equals("json")) {
            response.setContentType("application/json");
            if (reqInfo.instances) {
                if (reqInfo.name == null) {
                    this.getAllInstances(response.getWriter());
                    return;
                }
                this.getInstanceDetail(response.getWriter(), reqInfo.name);
                return;
            }
            if (reqInfo.factories) {
                if (reqInfo.name == null) {
                    this.getAllFactories(response.getWriter());
                    return;
                }
                this.getFactoryDetail(response.getWriter(), reqInfo.name);
                return;
            }
            if (reqInfo.handlers) {
                this.getAllHandlers(response.getWriter());
            }
            return;
        }
        super.doGet(request, response);
    }

    public URL getResource(String path) {
        URL uRL;
        if (!this.__MgetResource$java_lang_String) {
            return this.__M_getResource(path);
        }
        try {
            this.__IM.onEntry((Object)this, "getResource$java_lang_String", new Object[]{path});
            uRL = this.__M_getResource(path);
            this.__IM.onExit((Object)this, "getResource$java_lang_String", (Object)uRL);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getResource$java_lang_String", throwable);
            throw throwable;
        }
        return uRL;
    }

    private URL __M_getResource(String path) {
        if (path.contains("/res/ui/")) {
            return ((Object)((Object)this)).getClass().getResource(path.substring(this.__getm_label().length() + 1));
        }
        return null;
    }

    private JSONArray getProvidedServiceDetail(HandlerDescription hd) throws JSONException {
        JSONArray jSONArray;
        if (!this.__MgetProvidedServiceDetail$org_apache_felix_ipojo_architecture_HandlerDescription) {
            return this.__M_getProvidedServiceDetail(hd);
        }
        try {
            this.__IM.onEntry((Object)this, "getProvidedServiceDetail$org_apache_felix_ipojo_architecture_HandlerDescription", new Object[]{hd});
            jSONArray = this.__M_getProvidedServiceDetail(hd);
            this.__IM.onExit((Object)this, "getProvidedServiceDetail$org_apache_felix_ipojo_architecture_HandlerDescription", (Object)jSONArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getProvidedServiceDetail$org_apache_felix_ipojo_architecture_HandlerDescription", throwable);
            throw throwable;
        }
        return jSONArray;
    }

    private JSONArray __M_getProvidedServiceDetail(HandlerDescription hd) throws JSONException {
        if (hd == null) {
            return null;
        }
        JSONArray array = new JSONArray();
        ProvidedServiceHandlerDescription desc = (ProvidedServiceHandlerDescription)hd;
        for (ProvidedServiceDescription ps : desc.getProvidedServices()) {
            JSONObject svc = new JSONObject();
            String spec = Arrays.toString(ps.getServiceSpecifications());
            if (spec.startsWith("[")) {
                spec = spec.substring(1, spec.length() - 1);
            }
            svc.put("specification", (Object)spec);
            svc.put("state", (Object)StateUtils.getProvidedServiceState(ps.getState()));
            if (ps.getServiceReference() != null) {
                svc.put("id", (Object)((Long)ps.getServiceReference().getProperty("service.id")));
            }
            if (ps.getProperties() != null && !ps.getProperties().isEmpty()) {
                svc.put("properties", (Object)this.getServiceProperties(ps.getProperties()));
            }
            array.put((Object)svc);
        }
        return array;
    }

    private JSONArray getServiceProperties(Properties properties) throws JSONException {
        JSONArray jSONArray;
        if (!this.__MgetServiceProperties$java_util_Properties) {
            return this.__M_getServiceProperties(properties);
        }
        try {
            this.__IM.onEntry((Object)this, "getServiceProperties$java_util_Properties", new Object[]{properties});
            jSONArray = this.__M_getServiceProperties(properties);
            this.__IM.onExit((Object)this, "getServiceProperties$java_util_Properties", (Object)jSONArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getServiceProperties$java_util_Properties", throwable);
            throw throwable;
        }
        return jSONArray;
    }

    private JSONArray __M_getServiceProperties(Properties properties) throws JSONException {
        JSONArray array = new JSONArray();
        Enumeration<Object> e = properties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object value = properties.get(key);
            JSONObject prop = new JSONObject();
            prop.put("name", (Object)key);
            if (value != null && value.getClass().isArray()) {
                prop.put("value", (Object)Arrays.toString((Object[])value));
            } else if (value != null) {
                prop.put("value", (Object)value.toString());
            } else {
                prop.put("value", (Object)"no value");
            }
            array.put((Object)prop);
        }
        return array;
    }

    private JSONArray getRequiredServiceDetail(HandlerDescription hd) throws JSONException {
        JSONArray jSONArray;
        if (!this.__MgetRequiredServiceDetail$org_apache_felix_ipojo_architecture_HandlerDescription) {
            return this.__M_getRequiredServiceDetail(hd);
        }
        try {
            this.__IM.onEntry((Object)this, "getRequiredServiceDetail$org_apache_felix_ipojo_architecture_HandlerDescription", new Object[]{hd});
            jSONArray = this.__M_getRequiredServiceDetail(hd);
            this.__IM.onExit((Object)this, "getRequiredServiceDetail$org_apache_felix_ipojo_architecture_HandlerDescription", (Object)jSONArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRequiredServiceDetail$org_apache_felix_ipojo_architecture_HandlerDescription", throwable);
            throw throwable;
        }
        return jSONArray;
    }

    private JSONArray __M_getRequiredServiceDetail(HandlerDescription hd) throws JSONException {
        if (hd == null) {
            return null;
        }
        JSONArray array = new JSONArray();
        DependencyHandlerDescription desc = (DependencyHandlerDescription)hd;
        for (DependencyDescription dep : desc.getDependencies()) {
            JSONObject req = new JSONObject();
            req.put("specification", (Object)dep.getSpecification());
            req.put("id", (Object)dep.getId());
            req.put("state", (Object)StateUtils.getDependencyState(dep.getState()));
            req.put("policy", (Object)StateUtils.getDependencyBindingPolicy(dep.getPolicy()));
            req.put("optional", dep.isOptional());
            req.put("aggregate", dep.isMultiple());
            if (dep.getFilter() != null) {
                req.put("filter", (Object)dep.getFilter());
            }
            if (dep.getServiceReferences() != null && dep.getServiceReferences().size() != 0) {
                req.put("matching", (Object)this.getServiceReferenceList(dep.getServiceReferences()));
            }
            if (dep.getUsedServices() != null && dep.getUsedServices().size() != 0) {
                req.put("used", (Object)this.getServiceReferenceList(dep.getUsedServices()));
            }
            array.put((Object)req);
        }
        return array;
    }

    private JSONArray getServiceReferenceList(List<ServiceReference> refs) throws JSONException {
        JSONArray jSONArray;
        if (!this.__MgetServiceReferenceList$java_util_List) {
            return this.__M_getServiceReferenceList(refs);
        }
        try {
            this.__IM.onEntry((Object)this, "getServiceReferenceList$java_util_List", new Object[]{refs});
            jSONArray = this.__M_getServiceReferenceList(refs);
            this.__IM.onExit((Object)this, "getServiceReferenceList$java_util_List", (Object)jSONArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getServiceReferenceList$java_util_List", throwable);
            throw throwable;
        }
        return jSONArray;
    }

    private JSONArray __M_getServiceReferenceList(List<ServiceReference> refs) throws JSONException {
        JSONArray array = new JSONArray();
        if (refs != null) {
            for (ServiceReference ref : refs) {
                JSONObject reference = new JSONObject();
                if (ref.getProperty("instance.name") == null) {
                    reference.put("id", ref.getProperty("service.id"));
                } else {
                    reference.put("id", ref.getProperty("service.id"));
                    reference.put("instance", ref.getProperty("instance.name"));
                }
                array.put((Object)reference);
            }
        }
        return array;
    }

    public String getLabel() {
        String string;
        if (!this.__MgetLabel) {
            return this.__M_getLabel();
        }
        try {
            this.__IM.onEntry((Object)this, "getLabel", new Object[0]);
            string = this.__M_getLabel();
            this.__IM.onExit((Object)this, "getLabel", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getLabel", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getLabel() {
        return this.__getm_label();
    }

    public String getTitle() {
        String string;
        if (!this.__MgetTitle) {
            return this.__M_getTitle();
        }
        try {
            this.__IM.onEntry((Object)this, "getTitle", new Object[0]);
            string = this.__M_getTitle();
            this.__IM.onExit((Object)this, "getTitle", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTitle", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getTitle() {
        return this.__getm_title();
    }

    protected String[] getCssReferences() {
        String[] stringArray;
        if (!this.__MgetCssReferences) {
            return this.__M_getCssReferences();
        }
        try {
            this.__IM.onEntry((Object)this, "getCssReferences", new Object[0]);
            stringArray = this.__M_getCssReferences();
            this.__IM.onExit((Object)this, "getCssReferences", (Object)stringArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getCssReferences", throwable);
            throw throwable;
        }
        return stringArray;
    }

    private String[] __M_getCssReferences() {
        return CSS;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("FACTORIES")) {
                this.__FFACTORIES = true;
            }
            if (set.contains("FACTORY_DETAILS")) {
                this.__FFACTORY_DETAILS = true;
            }
            if (set.contains("HANDLERS")) {
                this.__FHANDLERS = true;
            }
            if (set.contains("INSTANCES")) {
                this.__FINSTANCES = true;
            }
            if (set.contains("INSTANCE_DETAILS")) {
                this.__FINSTANCE_DETAILS = true;
            }
            if (set.contains("m_archs")) {
                this.__Fm_archs = true;
            }
            if (set.contains("m_css")) {
                this.__Fm_css = true;
            }
            if (set.contains("m_factories")) {
                this.__Fm_factories = true;
            }
            if (set.contains("m_handlers")) {
                this.__Fm_handlers = true;
            }
            if (set.contains("m_label")) {
                this.__Fm_label = true;
            }
            if (set.contains("m_title")) {
                this.__Fm_title = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("readTemplate$java_lang_String")) {
                this.__MreadTemplate$java_lang_String = true;
            }
            if (set.contains("renderContent$javax_servlet_http_HttpServletRequest$javax_servlet_http_HttpServletResponse")) {
                this.__MrenderContent$javax_servlet_http_HttpServletRequest$javax_servlet_http_HttpServletResponse = true;
            }
            if (set.contains("getAllInstances$java_io_PrintWriter")) {
                this.__MgetAllInstances$java_io_PrintWriter = true;
            }
            if (set.contains("getAllFactories$java_io_PrintWriter")) {
                this.__MgetAllFactories$java_io_PrintWriter = true;
            }
            if (set.contains("getAllHandlers$java_io_PrintWriter")) {
                this.__MgetAllHandlers$java_io_PrintWriter = true;
            }
            if (set.contains("getFactoryDetail$java_io_PrintWriter$java_lang_String")) {
                this.__MgetFactoryDetail$java_io_PrintWriter$java_lang_String = true;
            }
            if (set.contains("getInstanceDetail$java_io_PrintWriter$java_lang_String")) {
                this.__MgetInstanceDetail$java_io_PrintWriter$java_lang_String = true;
            }
            if (set.contains("doGet$javax_servlet_http_HttpServletRequest$javax_servlet_http_HttpServletResponse")) {
                this.__MdoGet$javax_servlet_http_HttpServletRequest$javax_servlet_http_HttpServletResponse = true;
            }
            if (set.contains("getResource$java_lang_String")) {
                this.__MgetResource$java_lang_String = true;
            }
            if (set.contains("getProvidedServiceDetail$org_apache_felix_ipojo_architecture_HandlerDescription")) {
                this.__MgetProvidedServiceDetail$org_apache_felix_ipojo_architecture_HandlerDescription = true;
            }
            if (set.contains("getServiceProperties$java_util_Properties")) {
                this.__MgetServiceProperties$java_util_Properties = true;
            }
            if (set.contains("getRequiredServiceDetail$org_apache_felix_ipojo_architecture_HandlerDescription")) {
                this.__MgetRequiredServiceDetail$org_apache_felix_ipojo_architecture_HandlerDescription = true;
            }
            if (set.contains("getServiceReferenceList$java_util_List")) {
                this.__MgetServiceReferenceList$java_util_List = true;
            }
            if (set.contains("getLabel")) {
                this.__MgetLabel = true;
            }
            if (set.contains("getTitle")) {
                this.__MgetTitle = true;
            }
            if (set.contains("getCssReferences")) {
                this.__MgetCssReferences = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }

    private final class RequestInfo {
        public final String extension;
        public final String path;
        public final boolean instances;
        public final boolean factories;
        public final boolean handlers;
        public final String name;

        protected RequestInfo(HttpServletRequest request) {
            String info = request.getPathInfo();
            info = info.substring(IPOJOPlugin.this.getLabel().length() + 1);
            if (info.endsWith(".json")) {
                this.extension = "json";
                info = info.substring(0, info.length() - 5);
            } else {
                this.extension = "html";
            }
            if (info.startsWith("/")) {
                this.path = info.substring(1);
                this.instances = this.path.startsWith("instances");
                this.factories = this.path.startsWith("factories");
                this.handlers = this.path.startsWith("handlers");
                this.name = this.instances && this.path.startsWith("instances/") ? this.path.substring("instances".length() + 1) : (this.factories && this.path.startsWith("factories/") ? this.path.substring("factories".length() + 1) : null);
            } else {
                this.path = null;
                this.name = null;
                this.instances = false;
                this.factories = false;
                this.handlers = false;
            }
            request.setAttribute(IPOJOPlugin.class.getName(), (Object)this);
        }
    }
}

