/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.test.scenarios.manipulation;

import java.util.List;
import java.util.Properties;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.junit4osgi.OSGiTestCase;
import org.apache.felix.ipojo.junit4osgi.helpers.IPOJOHelper;
import org.apache.felix.ipojo.test.scenarios.manipulation.service.CheckService;
import org.osgi.framework.ServiceReference;

public class TypedList
extends OSGiTestCase {
    ComponentInstance foo1;
    ComponentInstance foo2;
    ComponentInstance checker;
    IPOJOHelper helper;

    public void setUp() {
        this.helper = new IPOJOHelper((OSGiTestCase)this);
        this.foo1 = this.helper.createComponentInstance("org.apache.felix.ipojo.test.scenarios.component.FooServiceImpl", "foo1");
        this.foo2 = this.helper.createComponentInstance("org.apache.felix.ipojo.test.scenarios.component.FooServiceImpl", "foo2");
        this.checker = this.helper.createComponentInstance("TypedList", "checker");
        this.foo1.stop();
        this.foo2.stop();
    }

    public void tearDown() {
        this.helper.dispose();
    }

    public void testTypedList() {
        ServiceReference ref = this.helper.getServiceReferenceByName(CheckService.class.getName(), this.checker.getInstanceName());
        CheckService check = (CheckService)this.getServiceObject(ref);
        TypedList.assertNotNull((String)"Checker availability", (Object)check);
        TypedList.assertFalse((String)"Empty list", (boolean)check.check());
        this.foo1.start();
        TypedList.assertTrue((String)"List with one element", (boolean)check.check());
        Properties props = check.getProps();
        List list = (List)props.get("list");
        TypedList.assertEquals((String)"Check size - 1", (int)1, (int)list.size());
        this.foo2.start();
        TypedList.assertTrue((String)"List with two element", (boolean)check.check());
        props = check.getProps();
        list = (List)props.get("list");
        TypedList.assertEquals((String)"Check size - 2", (int)2, (int)list.size());
        this.foo1.stop();
        TypedList.assertTrue((String)"List with one element (2)", (boolean)check.check());
        props = check.getProps();
        list = (List)props.get("list");
        TypedList.assertEquals((String)"Check size - 3", (int)1, (int)list.size());
    }
}

