/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.internal;

import java.nio.charset.Charset;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.util.CharsetStringBuilder;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.thread.Invocable;

public class ContentSourceString {
    private final Content.Source content;
    private final CharsetStringBuilder text;
    private final Promise<String> promise;
    private final DemandTask _demandTask;

    public ContentSourceString(Content.Source content, Charset charset, Promise<String> promise) {
        this.content = content;
        this.text = CharsetStringBuilder.forCharset(charset);
        this.promise = promise;
        this._demandTask = new DemandTask();
    }

    public void convert() {
        Content.Chunk chunk;
        do {
            if ((chunk = this.content.read()) == null) {
                this.content.demand(this._demandTask);
                return;
            }
            if (Content.Chunk.isFailure(chunk)) {
                this.promise.failed(chunk.getFailure());
                if (!chunk.isLast()) {
                    this.content.fail(chunk.getFailure());
                }
                return;
            }
            this.text.append(chunk.getByteBuffer());
            chunk.release();
        } while (!chunk.isLast());
        this.succeed();
    }

    private void succeed() {
        try {
            String result = this.text.build();
            this.promise.succeeded(result);
        }
        catch (Throwable x) {
            this.promise.failed(x);
        }
    }

    private class DemandTask
    extends Invocable.Task.Abstract {
        DemandTask() {
            super(Invocable.getInvocationType(ContentSourceString.this.promise));
        }

        @Override
        public void run() {
            ContentSourceString.this.convert();
        }
    }
}

