/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors;

import com.ibm.icu.util.ULocale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.daffodil.lib.cookers.Converter;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.exceptions.ThrowsSDE;
import scala.collection.immutable.Seq;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class LocaleConverter$
implements Converter<String, ULocale> {
    private static final String regex;
    private static final Pattern localePattern;
    public static final LocaleConverter$ MODULE$;

    private LocaleConverter$() {
    }

    static {
        MODULE$ = new LocaleConverter$();
        regex = "([A-Za-z]{1,8}([-_][A-Za-z0-9]{1,8})*)";
        localePattern = Pattern.compile(MODULE$.regex());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(LocaleConverter$.class);
    }

    public String regex() {
        return regex;
    }

    public Pattern localePattern() {
        return localePattern;
    }

    @Override
    public ULocale convert(String b, ThrowsSDE context, boolean forUnparse) {
        Matcher m = this.localePattern().matcher(b);
        if (m.matches()) {
            String canonicalCalLang = ULocale.canonicalize((String)b);
            if (canonicalCalLang == null) {
                throw Assert$.MODULE$.abort("Invariant broken: canonicalCalLang.ne(null)");
            }
            ULocale l = new ULocale(canonicalCalLang);
            return l;
        }
        throw context.schemaDefinitionError("dfdl:calendarLanguage property syntax error. Must match '%s' (ex: 'en_us' or 'de_1996'), but was '%s'.", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.regex(), b}));
    }
}

