/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.infoset;

import java.io.Serializable;
import java.util.Map;
import org.apache.daffodil.api.Daffodil;
import org.apache.daffodil.api.infoset.InfosetInputter;
import org.apache.daffodil.lib.util.MStackOf;
import org.apache.daffodil.lib.xml.NS$;
import org.apache.daffodil.lib.xml.XMLUtils$;
import org.apache.daffodil.runtime1.dpath.NodeInfo;
import org.apache.daffodil.runtime1.infoset.IllegalContentWhereEventExpected;
import org.apache.daffodil.runtime1.infoset.InvalidInfosetException;
import org.apache.daffodil.runtime1.infoset.NonTextFoundInSimpleContentException;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.xml.Atom;
import scala.xml.Comment;
import scala.xml.Elem;
import scala.xml.EntityRef;
import scala.xml.Node;
import scala.xml.ProcInstr;
import scala.xml.Text;

public class ScalaXMLInfosetInputter
extends InfosetInputter {
    private final MStackOf<Tuple2<Elem, Iterator<Node>>> stack;
    private boolean doStartEvent;

    /*
     * WARNING - void declaration
     */
    public ScalaXMLInfosetInputter(Node rootNode) {
        void var2_2;
        MStackOf<Tuple2> s = new MStackOf<Tuple2>();
        Node node = rootNode;
        if (!(node instanceof Elem)) {
            throw new InvalidInfosetException("Root node is not an element");
        }
        Elem e = (Elem)node;
        Iterator iter = e.iterator();
        s.push(Tuple2$.MODULE$.apply(null, (Object)iter));
        this.stack = var2_2;
        this.doStartEvent = true;
    }

    @Override
    public Daffodil.InfosetInputterEventType getEventType() {
        if (this.stack.top()._1() == null) {
            if (this.doStartEvent) {
                return Daffodil.InfosetInputterEventType.StartDocument;
            }
            return Daffodil.InfosetInputterEventType.EndDocument;
        }
        if (this.doStartEvent) {
            return Daffodil.InfosetInputterEventType.StartElement;
        }
        return Daffodil.InfosetInputterEventType.EndElement;
    }

    @Override
    public String getLocalName() {
        return ((Elem)this.stack.top()._1()).label();
    }

    @Override
    public boolean getSupportsNamespaces() {
        return true;
    }

    @Override
    public String getNamespaceURI() {
        return ((Node)this.stack.top()._1()).namespace();
    }

    @Override
    public String getSimpleText(NodeInfo.Kind primType, Map<String, String> runtimeProperties) {
        String unescaped;
        StringBuilder sb = new StringBuilder();
        Iterator iter = (Iterator)this.stack.top()._2();
        while (iter.hasNext()) {
            Node n = (Node)iter.next();
            Node node = n;
            if (node instanceof Text) {
                Text txt = (Text)node;
                txt.addString(sb);
                continue;
            }
            if (node instanceof Atom) {
                Atom atom = (Atom)node;
                sb.append(atom.text());
                continue;
            }
            if (node instanceof EntityRef) {
                EntityRef er = (EntityRef)node;
                StringOps$.MODULE$.addString$extension(Predef$.MODULE$.augmentString(er.text()), sb);
                continue;
            }
            Node x = node;
            throw new NonTextFoundInSimpleContentException(((Elem)this.stack.top()._1()).label());
        }
        String strWithEscapes = sb.toString();
        String text = unescaped = XMLUtils$.MODULE$.unescape(strWithEscapes);
        String result = primType instanceof NodeInfo.PrimType.StringKind ? XMLUtils$.MODULE$.remapPUAToXMLIllegalCharacters(text) : text;
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Boolean isNilled() {
        Boolean bl;
        String nilAttrValue;
        Elem elem;
        block10: {
            block9: {
                elem = (Elem)this.stack.top()._1();
                Option nilAttrValueOpt = elem.attribute(NS$.MODULE$.implicitNStoString(XMLUtils$.MODULE$.XSI_NAMESPACE()), "nil");
                if (nilAttrValueOpt.isEmpty()) {
                    return null;
                }
                Seq nilAttrValueSeq = (Seq)nilAttrValueOpt.get();
                if (nilAttrValueSeq.length() > 1) {
                    throw new InvalidInfosetException("multiple xsi:nil properties for element " + elem.label());
                }
                String string = nilAttrValue = ((Node)nilAttrValueSeq.head()).toString();
                String string2 = "true";
                if (!(string == null ? string2 != null : !string.equals(string2))) break block9;
                String string3 = nilAttrValue;
                String string4 = "1";
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block10;
            }
            bl = Predef$.MODULE$.boolean2Boolean(true);
            return bl;
        }
        String string = nilAttrValue;
        String string5 = "false";
        if (string == null ? string5 != null : !string.equals(string5)) {
            String string6 = nilAttrValue;
            String string7 = "0";
            if (string6 == null) {
                if (string7 != null) {
                    throw new InvalidInfosetException("xsi:nil property is not a valid boolean: '" + nilAttrValue + "' for element " + elem.label());
                }
            } else if (!string6.equals(string7)) throw new InvalidInfosetException("xsi:nil property is not a valid boolean: '" + nilAttrValue + "' for element " + elem.label());
        }
        bl = Predef$.MODULE$.boolean2Boolean(false);
        return bl;
    }

    @Override
    public boolean hasNext() {
        boolean atDocumentEnd = this.stack.top()._1() == null && !this.doStartEvent;
        return !atDocumentEnd;
    }

    @Override
    public void fini() {
        this.stack.clear();
    }

    private boolean tryDescend() {
        boolean descended = false;
        while (((Iterator)this.stack.top()._2()).hasNext() && !descended) {
            Text t;
            Node node = (Node)((Iterator)this.stack.top()._2()).next();
            if (node instanceof Elem) {
                Elem e = (Elem)node;
                this.stack.push((Tuple2<Elem, Iterator<Node>>)Tuple2$.MODULE$.apply((Object)e, (Object)e.child().iterator()));
                descended = true;
                continue;
            }
            if (node instanceof Text && StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString((String)(t = (Text)node).data()), (Function1 & Serializable)_$1 -> RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)_$1)))) || node instanceof ProcInstr || node instanceof Comment) continue;
            Node c = node;
            throw new IllegalContentWhereEventExpected("Found " + c.getClass().getName());
        }
        return descended;
    }

    @Override
    public void next() {
        if (this.tryDescend()) {
            this.doStartEvent = true;
            return;
        }
        if (this.doStartEvent) {
            this.doStartEvent = false;
            return;
        }
        this.stack.pop();
        if (this.tryDescend()) {
            this.doStartEvent = true;
            return;
        }
    }
}

